/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_BUTTON_H_
#define _LF_BUTTON_H_


#include "mforms/button.h"

#include "lf_view.h"


namespace mforms {
namespace gtk {

class ButtonImpl : public ViewImpl
{
 protected:
  Gtk::Button *_button;
  Gtk::Alignment *_align;
  Gtk::Label *_label;
  
  virtual Gtk::Widget *get_outer() const { return _button; }

  ButtonImpl(::mforms::Button *self, bool concrete= false)
    : ViewImpl(self), _button(0), _align(0), _label(0)
  {
    if (concrete)
    {
      _align= Gtk::manage(new Gtk::Alignment());
      _label= Gtk::manage(new Gtk::Label());
      _align->add(*_label);
      _button= Gtk::manage(new Gtk::Button());
      _button->add(*_align);
      //_button->signal_clicked().connect(sigc::mem_fun(*self, &::mforms::Button::callback));
      _button->signal_clicked().connect(sigc::bind(sigc::ptr_fun(&ButtonImpl::callback), self));

      _button->show_all();
      setup();
    }
  }

  static void callback(::mforms::Button* self)
  {
    self->callback();
  }

  static bool create(::mforms::Button *self)
  {
    return new ButtonImpl(self, true) != 0;
  }

  static void set_text(::mforms::Button *self, const std::string &text)
  {
    if ( self )
    {
      ButtonImpl* button = self->get_data<ButtonImpl>();

      if ( button )
      {
        if (button->_label)
          button->_label->set_label(text);
        else
          button->_button->set_label(text);
      }
    }
  }

  static void enable_internal_padding(Button *self, bool enabled)
  {
    ButtonImpl* button = self->get_data<ButtonImpl>();
    if (button)
    {
      if (enabled)
        button->_align->set_padding(0, 0, 8, 8);
      else
        button->_align->set_padding(0, 0, 0, 0);
    }
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_button_impl.create= &ButtonImpl::create;
    f->_button_impl.set_text= &ButtonImpl::set_text;
    f->_button_impl.enable_internal_padding= &ButtonImpl::enable_internal_padding;
  }
};

}
}

#endif
