/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_CHECKBOX_H_
#define _LF_CHECKBOX_H_

#include <mforms/mforms.h>

#include "lf_button.h"

namespace mforms {
namespace gtk {

class CheckBoxImpl : public ButtonImpl
{
  Gtk::CheckButton *_check;
  virtual Gtk::Widget *get_outer() const { return _check; }

 protected:
  static bool create(::mforms::CheckBox *self)
  {
    return new CheckBoxImpl(self) != 0;
  }

  static void set_active(::mforms::CheckBox *self, bool flag)
  {
    CheckBoxImpl* cb = self->get_data<CheckBoxImpl>();

    if ( cb )
      cb->_check->set_active(flag);
  }

  static bool get_active(::mforms::CheckBox *self)
  {
    CheckBoxImpl* cb = self->get_data<CheckBoxImpl>();
    return ( cb ? cb->_check->get_active() : false);
  }

  CheckBoxImpl(::mforms::CheckBox *self)
    : ButtonImpl(self)
  {
    delete _button;
    _check = Gtk::manage(new Gtk::CheckButton());
    _check->signal_clicked().connect(sigc::bind(sigc::ptr_fun(&CheckBoxImpl::callback), self));
    _button= _check;
  }

  static void callback(::mforms::CheckBox* self)
  {
    self->callback();
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

    f->_checkbox_impl.create     = &CheckBoxImpl::create;
    f->_checkbox_impl.set_active = &CheckBoxImpl::set_active;
    f->_checkbox_impl.get_active = &CheckBoxImpl::get_active;
  }
};

};
};

#endif
