/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_LABEL_H_
#define _LF_LABEL_H_


#include "mforms/label.h"

#include "lf_view.h"

namespace mforms {
namespace gtk {

class LabelImpl : public ViewImpl
{
protected:
  Gtk::Label *_label;
  
  virtual Gtk::Widget *get_outer() const
  {
    return _label;
  }

  LabelImpl(::mforms::Label *self)
    : ViewImpl(self)
  {
    _label = Gtk::manage(new Gtk::Label("label"));
    _label->set_alignment(0, 0.5);

    setup();    
  }

  static bool create(::mforms::Label *self)
  {
    return new LabelImpl(self) != 0;
  }

  static void set_style(::mforms::Label *self, ::mforms::LabelStyle style)
  {
    LabelImpl* label = self->get_data<LabelImpl>();

    if ( label )
    {
      switch (style)
      {
      case ::mforms::NormalStyle:
        //l->Font= gcnew System::Drawing::Font(l->Font, System::Drawing::FontStyle::Regular);
        break;
      case ::mforms::BigStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_size(font.get_size()*3/2);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::BigBoldStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_size(font.get_size()*3/2);
          font.set_weight(Pango::WEIGHT_BOLD);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::BoldStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_weight(Pango::WEIGHT_BOLD);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::SmallStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_size(font.get_size()*5/6);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::VerySmallStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_size(font.get_size()*3/5);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::InfoCaptionStyle:
        break;
      case ::mforms::BoldInfoCaptionStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_weight(Pango::WEIGHT_BOLD);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::WizardHeadingStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_size(font.get_size()*1.2);
          font.set_weight(Pango::WEIGHT_BOLD);
          label->_label->modify_font(font);
        }
        break;
      case ::mforms::SmallHelpTextStyle:
        {
          Pango::FontDescription font(label->_label->get_pango_context()->get_font_description());
          font.set_size(font.get_size()*4/5);
          label->_label->modify_font(font);
        }
        break;
      }
    }
  }

  static void set_text(::mforms::Label *self, const std::string &text)
  {
    LabelImpl* label = self->get_data<LabelImpl>();

    if ( label )
    {   
      ((Gtk::Label*)label->_label)->set_text(text);
    }
  }

  static void set_color(::mforms::Label *self, const std::string &text)
  {
    LabelImpl* label = self->get_data<LabelImpl>();

    if ( label )
    {
      Gdk::Color color(text);
      ((Gtk::Label*)label->_label)->get_colormap()->alloc_color(color);
      ((Gtk::Label*)label->_label)->modify_fg(Gtk::STATE_NORMAL, color);
    }
  }

  static void set_wrap_text(::mforms::Label *self, bool flag)
  {
    LabelImpl* label = self->get_data<LabelImpl>();

    if ( label )
    {   
      ((Gtk::Label*)label->_label)->set_line_wrap(flag);
    }
  }

  static void set_text_align(::mforms::Label *self, ::mforms::Alignment align)
  {
    LabelImpl* label = self->get_data<LabelImpl>();

    if ( label )
    {
      /*
      Gtk::Justification gtk_align = Gtk::JUSTIFY_LEFT;
      if ( align == mforms::BottomCenter || align == mforms::MiddleCenter || mforms::TopCenter )
        gtk_align = Gtk::JUSTIFY_CENTER;
      if ( align == mforms::BottomRight || align == mforms::MiddleRight || mforms::TopRight )
        gtk_align = Gtk::JUSTIFY_RIGHT;

      ((Gtk::Label*)label->_label)->set_justify(gtk_align);
       */
      
      float x, y;
      switch (align)
      {
      case ::mforms::BottomLeft:   x= 0;   y= 1; break;
      case ::mforms::BottomCenter: x= 0.5; y= 1; break;
      case ::mforms::BottomRight:  x= 1;   y= 1; break;
      case ::mforms::MiddleLeft:   x= 0;   y= 0.5; break;
      case ::mforms::MiddleCenter: x= 0.5; y= 0.5; break;
      case ::mforms::MiddleRight:  x= 1;   y= 0.5; break;
      case ::mforms::TopLeft:      x= 0;   y= 0; break;
      case ::mforms::TopCenter:    x= 0.5; y= 0; break;
      case ::mforms::TopRight:     x= 1;   y= 0; break;
      case ::mforms::WizardLabelAlignment: g_message("mforms::WizardLabelAlignment not handled. %s:%i", __FILE__, __LINE__); break;
      }
      ((Gtk::Label*)label->_label)->set_alignment(x, y);
    }
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_label_impl.create         = &LabelImpl::create;
    f->_label_impl.set_style      = &LabelImpl::set_style;
    f->_label_impl.set_text       = &LabelImpl::set_text;
    f->_label_impl.set_text_align = &LabelImpl::set_text_align;
    f->_label_impl.set_color      = &LabelImpl::set_color;
    f->_label_impl.set_wrap_text  = &LabelImpl::set_wrap_text;
  }
};

};
};


#endif
