/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_PROGRESSBAR_H_
#define _LF_PROGRESSBAR_H_


#include "mforms/progressbar.h"

#include "lf_view.h"

namespace mforms {
namespace gtk {

class ProgressBarImpl : public ViewImpl
{
 protected:
  Gtk::ProgressBar *_pbar;
  virtual Gtk::Widget *get_outer() const { return _pbar; }
  

  ProgressBarImpl(::mforms::ProgressBar *self)
    : ViewImpl(self)
  {
    _pbar= Gtk::manage(new Gtk::ProgressBar());

    setup();
  }

  static bool create(::mforms::ProgressBar *self)
  {
    return new ProgressBarImpl(self) != 0;
  }
  
  static void set_value(::mforms::ProgressBar *self, float pct)
  {
    ProgressBarImpl *progressbar= self->get_data<ProgressBarImpl>();
    
    if (progressbar)
      progressbar->_pbar->set_fraction(pct);
  }

  static void set_started(::mforms::ProgressBar *self, bool flag)
  {
  }

  static void set_indeterminate(::mforms::ProgressBar *self, bool flag)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_progressbar_impl.create         = &ProgressBarImpl::create;
    f->_progressbar_impl.set_value      = &ProgressBarImpl::set_value;
    f->_progressbar_impl.set_started    = &ProgressBarImpl::set_started;
    f->_progressbar_impl.set_indeterminate= &ProgressBarImpl::set_indeterminate;
  }
};

};
};


#endif /* _LF_PROGRESSBAR_H_ */
