/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_SCROLL_PANEL_H_
#define _LF_SCROLL_PANEL_H_


#include "mforms/scrollpanel.h"

#include "lfi_container.h"

namespace mforms
{
namespace gtk
{

class ScrollPanelImpl : public ContainerImpl
{
  Gtk::ScrolledWindow *_swin;
  bool _vertical, _horizontal;
  bool _autohide;

  virtual Gtk::Widget *get_outer() const { return _swin; }
  virtual Gtk::Widget *get_inner() const { return _swin; }
  
protected:
  ScrollPanelImpl(::mforms::ScrollPanel *self, bool bordered)
    : ContainerImpl(self)
  {
    _swin= Gtk::manage(new Gtk::ScrolledWindow());

    _swin->set_policy(Gtk::POLICY_ALWAYS, Gtk::POLICY_ALWAYS);
    _vertical = true;
    _horizontal = true;
    _autohide = true;
    
    if (bordered)
      _swin->set_shadow_type(Gtk::SHADOW_IN);
    else
      _swin->set_shadow_type(Gtk::SHADOW_NONE);
  }

  static bool create(::mforms::ScrollPanel *self, bool bordered)
  {
    return new ScrollPanelImpl(self, bordered) != 0;
  }

  static void add(::mforms::ScrollPanel *self, ::mforms::View *child)
  {
    ScrollPanelImpl *panel= self->get_data<ScrollPanelImpl>();

    panel->_swin->add(*child->get_data<ViewImpl>()->get_outer());
    
    // remove border around viewport
    ((Gtk::Viewport*)panel->_swin->get_child())->set_shadow_type(Gtk::SHADOW_NONE);
  }

  static void remove(::mforms::ScrollPanel *self)
  {
    ScrollPanelImpl *panel= self->get_data<ScrollPanelImpl>();
    
    panel->_swin->remove();
  }

  static void set_visible_scrollers(::mforms::ScrollPanel *self, bool vertical, bool horizontal)
  {
    ScrollPanelImpl *panel= self->get_data<ScrollPanelImpl>();
    panel->_vertical = vertical;
    panel->_horizontal = horizontal;
    panel->_swin->set_policy(panel->_autohide ? Gtk::POLICY_AUTOMATIC : (horizontal ? Gtk::POLICY_ALWAYS : Gtk::POLICY_NEVER),
			panel->_autohide ? Gtk::POLICY_AUTOMATIC : (vertical ? Gtk::POLICY_ALWAYS : Gtk::POLICY_NEVER));
  }

  static void set_autohide_scrollers(::mforms::ScrollPanel *self, bool flag)
  {
    ScrollPanelImpl *panel= self->get_data<ScrollPanelImpl>();

    panel->_autohide = flag;
    panel->_swin->set_policy(panel->_autohide ? Gtk::POLICY_AUTOMATIC : (panel->_horizontal ? Gtk::POLICY_ALWAYS : Gtk::POLICY_NEVER),
                             panel->_autohide ? Gtk::POLICY_AUTOMATIC : (panel->_vertical ? Gtk::POLICY_ALWAYS : Gtk::POLICY_NEVER));
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_spanel_impl.create         = &ScrollPanelImpl::create;

    f->_spanel_impl.add            = &ScrollPanelImpl::add;
    f->_spanel_impl.remove         = &ScrollPanelImpl::remove;    
    f->_spanel_impl.set_visible_scrollers  = &ScrollPanelImpl::set_visible_scrollers;    
    f->_spanel_impl.set_autohide_scrollers = &ScrollPanelImpl::set_autohide_scrollers;    
  }
};

};
};


#endif
