/* 
 * (c) 2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_SPLITTER_H_
#define _LF_SPLITTER_H_

#include "mforms/splitter.h"

#include "lf_view.h"


namespace mforms {
namespace gtk {

class SplitterImpl : public ViewImpl
{  
protected:
  Gtk::Paned *_paned;
  
  virtual Gtk::Widget *get_outer() const { return _paned; }

  SplitterImpl(::mforms::Splitter *self, bool horiz)
    : ViewImpl(self)
  {
    if (horiz)
      _paned= new Gtk::HPaned();
    else
      _paned= new Gtk::VPaned();
  }

  static bool create(::mforms::Splitter *self, bool horiz)
  {
    return new SplitterImpl(self, horiz);
  }

  static void add(Splitter *self, View *child, int minwidth)
  {
    SplitterImpl *splitview= self->get_data<SplitterImpl>();

    if (!splitview->_paned->get_child1())
      splitview->_paned->pack1(*child->get_data<ViewImpl>()->get_outer(), true, true);
    else
      splitview->_paned->pack2(*child->get_data<ViewImpl>()->get_outer(), true, true);
    child->show();
  }

  static void remove(Splitter *self, View *child)
  {
    SplitterImpl *splitview= self->get_data<SplitterImpl>();

    splitview->_paned->remove(*child->get_data<ViewImpl>()->get_outer());
  }
  
  static void set_position(Splitter *self, int pos)
  {
    SplitterImpl *splitview= self->get_data<SplitterImpl>();
    
    splitview->_paned->set_position(pos);
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_splitter_impl.create= &SplitterImpl::create;
    f->_splitter_impl.add= &SplitterImpl::add;
    f->_splitter_impl.remove= &SplitterImpl::remove;
    f->_splitter_impl.set_position= &SplitterImpl::set_position;
  }
  
  virtual ~SplitterImpl()
  {
    delete _paned;
  }
};

}
}


#endif /* _LF_SPLITTER_H_ */
