/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _LF_UTILITIES_H_
#define _LF_UTILITIES_H_

#include <mforms/mforms.h>
#include "gtk_helpers.h"

#include "lf_mforms.h"

namespace mforms {
namespace gtk {

class UtilitiesImpl
{
  static sigc::slot<void,std::string> open_url_slot;

  static int show_message(const std::string &title, const std::string &text,
                          const std::string &ok, const std::string &cancel,
                          const std::string &other);
  static int show_error(const std::string &title, const std::string &text,
                        const std::string &ok, const std::string &cancel,
                        const std::string &other);
  static int show_warning(const std::string &title, const std::string &text,
                        const std::string &ok, const std::string &cancel,
                        const std::string &other);
  static void show_wait_message(const std::string &title, const std::string &text);
  static bool hide_wait_message();
  static void set_clipboard_text(const std::string &text);
  static std::string get_clipboard_text();
  static void open_url(const std::string &url);
  static std::string get_special_folder(mforms::FolderType type);
  static void add_timeout(float interval, const sigc::slot<bool> &slot);

  static void store_password(const std::string &service, const std::string &account, const std::string &password);
  static bool find_password(const std::string &service, const std::string &account, std::string &password);
  static void forget_password(const std::string &service, const std::string &account);

public:
  static void init();
  static void set_open_url_slot(const sigc::slot<void,std::string> &slot);
};

};
};

#endif
