/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include "mforms/label.h"
#include "mforms/mforms.h"

using namespace mforms;


Label::Label(const std::string &text)
{
  _label_impl= &ControlFactory::get_instance()->_label_impl;
  
  _label_impl->create(this);

  set_text(text);
}


Label::Label()
{
  _label_impl= &ControlFactory::get_instance()->_label_impl;
  
  _label_impl->create(this);
}


void Label::set_text(const std::string &text)
{
  _label_impl->set_text(this, text);
}


void Label::set_color(const std::string &color)
{
  _label_impl->set_color(this, color);
}


void Label::set_text_align(Alignment align)
{
  _label_impl->set_text_align(this, align);
}


void Label::set_style(LabelStyle style)
{
  _label_impl->set_style(this, style);
}


void Label::set_wrap_text(bool flag)
{
  _label_impl->set_wrap_text(this, flag);
}
