/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/listbox.h>

#include <mforms/mforms.h>

using namespace mforms;


ListBox::ListBox(bool multi_select)
  : _updating(false)
{
  _listbox_impl= &ControlFactory::get_instance()->_listbox_impl;

  _listbox_impl->create(this, multi_select);
}


void ListBox::clear()
{
  _updating= true;
  _listbox_impl->clear(this);
  _updating= false;
}


void ListBox::set_heading(const std::string &text)
{
  _listbox_impl->set_heading(this, text);
}


int ListBox::add_item(const std::string &item)
{
  return _listbox_impl->add_item(this, item);
}


void ListBox::add_items(const std::list<std::string> &items)
{
  _listbox_impl->add_items(this, items);
}


void ListBox::set_selected(int index)
{
  _updating= true;
  _listbox_impl->set_index(this, index);
  _updating= false;
}


std::string ListBox::get_string_value()
{
  return _listbox_impl->get_text(this);
}


int ListBox::get_selected_index()
{
  return _listbox_impl->get_index(this);
}

std::vector<int> ListBox::get_selected_indices()
{
  return _listbox_impl->get_selected_indices(this);
}

void ListBox::selection_changed()
{
  if (!_updating)
    _signal_changed.emit();
}
