/*
 *  menu.cpp
 *  MySQLWorkbench
 *
 *  Created by Alfredo Kojima on 11/Nov/09.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */
#include "stdafx.h"
#include <mforms/mforms.h>

using namespace mforms;

Menu::Menu()
{
  _menu_impl= &ControlFactory::get_instance()->_menu_impl;
  
  _menu_impl->create(this);
}


void Menu::remove_item(int i)
{
  _menu_impl->remove_item(this, i);
}


int Menu::add_action(const std::string &caption, const std::string &action)
{
  return _menu_impl->add_action(this, caption, action);
}


int Menu::add_separator()
{
  return _menu_impl->add_separator(this);
}


int Menu::add_submenu(const std::string &caption, Menu *submenu)
{
  return _menu_impl->add_submenu(this, caption, submenu);
}


void Menu::set_item_enabled(int i, bool flag)
{
  _menu_impl->set_item_enabled(this, i, flag);
}


void Menu::set_handler(const sigc::slot<void, const std::string&> &action_handler)
{
  _action_handler = action_handler;
}


void Menu::popup_at(int x, int y)
{
  _menu_impl->popup_at(this, x, y);
}


void Menu::handle_action(const std::string &action)
{
  _action_handler(action);
}

