/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_APP_H_
#define _MFORMS_APP_H_

#include <mforms/base.h>

#include <sigc++/sigc++.h>

namespace mforms {

  class App;
  class AppView;

#ifndef SWIG
  struct AppImplPtrs
  {
    void (__stdcall *dock_view)(App *app, AppView *view, const std::string &position);
    void (__stdcall *undock_view)(App *app, AppView *view);

    void (__stdcall *set_status_text)(App *app, const std::string &title);
    
    void (__stdcall *set_view_title)(App *app, AppView *view, const std::string &title);
    std::string (__stdcall *get_resource_path)(App *app, const std::string &file);
    std::string (__stdcall *get_bounds)(App *app);
  };
#endif

  class MFORMS_EXPORT App : public Object
  {
  private:
    App() {}

  public:
    static App *get();

    void dock_view(AppView *view, const std::string &position);
    void undock_view(AppView *view);
    void set_view_title(AppView *view, const std::string &title);
    void set_status_text(const std::string &text);
    
    std::string get_resource_path(const std::string &file);
    void get_bounds(int* x, int* y, int* w, int* h);
  protected:
    AppImplPtrs *_app_impl;
  };
};

#endif
