/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_APPVIEW_H_
#define _MFORMS_APPVIEW_H_

#include <mforms/box.h>
#include <mforms/app.h>

#include "ui_form.h"
#include <sigc++/sigc++.h>

namespace bec {
  class UIForm;
};

namespace mforms {

#ifndef SWIG
  struct AppViewImplPtrs
  {
    // I *need* an own create function, even if AppView is derived from Box.
    // Otherwise I cannot tell appart which managed wrapper to create.
    bool (__stdcall *create)(AppView *self, bool horizontal);
  };
#endif

  class MFORMS_EXPORT AppView : public Box , public bec::UIForm
  {
  protected:
    AppViewImplPtrs* _app_view_impl;
    sigc::slot<bool> _on_close_slot;
    std::string _context_name;
    bool _is_main;
    
  public:
#ifdef _WIN32
    AppView(bool horiz, const std::string &context_name, bool is_main);
#else
    AppView(bool horiz, const std::string &context_name, bool is_main) : Box(horiz), _context_name(context_name), _is_main(is_main) {}
#endif
    void set_title(const std::string &title) { App::get()->set_view_title(this, title); }

    bool on_close() { return _on_close_slot(); }
    
  public:
#ifndef SWIG
    void set_on_close(const sigc::slot<bool> &slot) { _on_close_slot= slot; }
#endif
  protected:
    virtual bool is_main_form() { return _is_main; }
    virtual std::string get_form_context_name() const { return _context_name; }
  };
};

#endif
