/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_BOX_H_
#define _MFORMS_BOX_H_

#include <mforms/view.h>
#include <map>

namespace mforms {
  
  class Box;
  class Button;

#ifndef SWIG
  struct BoxImplPtrs
  {
    bool (__stdcall *create)(Box *self, bool horizontal);
    void (__stdcall *add)(Box *self, View *child, bool expand, bool fill);
    void (__stdcall *add_end)(Box *self, View *child, bool expand, bool fill);
    void (__stdcall *remove)(Box *self, View *child);
    void (__stdcall *set_homogeneous)(Box *self, bool);
    void (__stdcall *set_spacing)(Box *self, int);
    void (__stdcall *set_padding)(Box *self, int);
  };
#endif

  class MFORMS_EXPORT Box : public View
  {
  public:
    Box(bool horiz);
    
    void add(View *subview, bool expand, bool fill= false);
    void add_end(View *subview, bool expand, bool fill= false);
    virtual void remove(View *subview);

    void set_homogeneous(bool flag);
    void set_spacing(int space);
    void set_padding(int padding);
    
  protected:
    BoxImplPtrs *_box_impl;
  };
  
};

#endif /* _MFORMS_BOX_H_ */
