/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_BUTTON_H_
#define _MFORMS_BUTTON_H_

#include <mforms/view.h>

#include <sigc++/sigc++.h>

namespace mforms {
  class Button;

#ifndef SWIG
  struct ButtonImplPtrs
  {
    bool (__stdcall *create)(Button *self);
    void (__stdcall *set_text)(Button *self, const std::string &text);
    void (__stdcall *enable_internal_padding)(Button *self, bool);
  };
#endif

  class MFORMS_EXPORT Button : public View
  {
  public:
    Button();
    void enable_internal_padding(bool flag);
    void set_text(const std::string &text);

#ifndef SWIG
    sigc::signal<void> &signal_clicked() { return _clicked; }

  public:
    virtual void callback();
    
    bool is_updating() { return _updating; }
#endif
  protected:
    sigc::signal<void> _clicked;
    ButtonImplPtrs *_button_impl;
    bool _updating;
  };
};

#endif
