/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_CHECKBOX_H_
#define _MFORMS_CHECKBOX_H_

#include <mforms/base.h>
#include <mforms/button.h>


namespace mforms {
  class CheckBox;

#ifndef SWIG
  struct CheckBoxImplPtrs
  {
    bool (__stdcall *create)(CheckBox *self);
    void (__stdcall *set_active)(CheckBox *self, bool flag);
    bool (__stdcall *get_active)(CheckBox *self);
  };
#endif

  class MFORMS_EXPORT CheckBox : public Button
  {
  public:
    CheckBox();

    void set_active(bool flag);
    bool get_active();
    
    virtual int get_int_value() { return get_active() ? 1 : 0; }
    virtual bool get_bool_value() { return get_active(); }
    virtual std::string get_string_value() { return get_active() ? "1" : "0"; }
    
  protected:
    CheckBoxImplPtrs *_checkbox_impl;
  };
};

#endif
