/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_DRAWBOX_H_
#define _MFORMS_DRAWBOX_H_

#include <mforms/base.h>
#include <mforms/view.h>

#include "cairo/cairo.h"

namespace mforms 
{
  class DrawBox;
  
#ifndef SWIG
  struct DrawBoxImplPtrs
  {
    bool (__stdcall *create)(DrawBox *);
    void (__stdcall *set_needs_repaint)(DrawBox *);
  };
#endif
  
  class MFORMS_EXPORT DrawBox : public View
  {
  public:
    DrawBox();

    void set_needs_repaint();
    virtual void get_layout_size(int* w, int* h);
    
#ifndef SWIG
    virtual void repaint(cairo_t *cr, int x, int y, int w, int h) {}
    virtual void mouse_down(int button, int x, int y) {}
    virtual void mouse_up(int button, int x, int y) {}
    virtual void mouse_click(int button, int x, int y) {}
    virtual void mouse_double_click(int button, int x, int y) {}
    virtual void mouse_enter() {}
    virtual void mouse_leave() {}
    virtual void mouse_move(int x, int y) {}
#endif
  protected:
    DrawBoxImplPtrs *_drawbox_impl;
  };
};

#endif
