/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _MFORMS_FORM_H_
#define _MFORMS_FORM_H_

#include <mforms/base.h>
#include <mforms/view.h>

#ifdef __APPLE__
#define TOP_FORM_PADDING 20
#else
#define TOP_FORM_PADDING 12
#endif

namespace mforms {

  enum FormFlag
  {
    FormNone        = 0,
    FormSingleFrame = 1 << 0,
    FormDialogFrame = 1 << 1,
    FormResizable   = 1 << 2,
    FormMinimizable = 1 << 3,
    FormHideOnClose = 1 << 4,
    FormStayOnTop   = 1 << 5
  };

  class Form;
  class Button;

#ifndef SWIG
  struct MFORMS_EXPORT FormImplPtrs
  {
    bool (__stdcall *create)(Form *self, Form *owner, FormFlag flag);
    void (__stdcall *set_title)(Form *self, const std::string &title);
    void (__stdcall *show_modal)(Form *self, Button *accept, Button *cancel);
    bool (__stdcall *run_modal)(Form *self, Button *accept, Button *cancel);
    void (__stdcall *set_content)(Form *self, View *view);
    void (__stdcall *close)(Form *self);
    
    void (__stdcall *center)(Form *self);

    void (__stdcall *flush_events)(Form *self);
  };
#endif

  class MFORMS_EXPORT Form : public View, public sigc::trackable
  {
    FormImplPtrs *_form_impl;
    View *_content;
    bool _fixed_size;
    bool _release_on_close;

    sigc::signal<void> _closed_signal;
  public:
    Form(Form *owner, FormFlag flag= (FormFlag)(FormResizable | FormMinimizable));
    virtual ~Form();

    virtual void set_content(View *view);
    virtual void set_title(const std::string &title);
    virtual void show_modal(Button *accept, Button *cancel);
    virtual bool run_modal(Button *accept, Button *cancel);
    virtual void close();
    
    virtual void center();
    virtual void flush_events();

    void set_release_on_close(bool flag);
    
#ifndef SWIG
    sigc::signal<void>& signal_closed() { return _closed_signal; }
#endif

    void was_closed()
    {
      _closed_signal.emit();
      if (_release_on_close)
        release();
    }

    virtual void needs_resize();
  };
};

#endif
