/* 
 * (c) 2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


/**
 * Implementation of a composite used to select a file system object like a file, folder, device,
 * drive etc.
 */

#ifndef _FS_OBJECT_SELECTOR_H_
#define _FS_OBJECT_SELECTOR_H_

#include "mforms/label.h"
#include "mforms/box.h"
#include "mforms/button.h"
#include "mforms/textentry.h"
#include "mforms/filechooser.h"

namespace mforms {

  class MFORMS_EXPORT FsObjectSelector : public Box
  {
  private:
    Button* _browse_button;
    TextEntry* _edit;
    FileChooserType _type;
    std::string _extensions;
    sigc::slot<void> _on_validate;
    sigc::connection _browse_connection; // The connection created when connecting the browse callback.
  protected:
    void enable_file_browsing();
    void filename_changed();
    void browse_file_callback();
      
  public:
    FsObjectSelector(bool horizontal= true);
    FsObjectSelector(Button* button, TextEntry* edit);
    ~FsObjectSelector();

    void initialize(const std::string& initial_path, FileChooserType type, const std::string& extensions,
                   const std::string& button_text= "...", sigc::slot<void> on_validate= sigc::slot<void>());
    void set_filename(const std::string &path);
    std::string get_filename();
    void set_enabled(bool value);
    void set_browse_callback(sigc::slot<void> browse_callback);

    TextEntry *get_entry() const { return _edit; }
    
    virtual std::string get_string_value();
    virtual int get_int_value();
    virtual bool get_bool_value();

#ifndef SWIG
    sigc::signal<void>& signal_changed() { return _edit->signal_changed(); }
#endif
    
    static void clear_stored_filenames();
    static bool check_and_confirm_file_overwrite(TextEntry* entry);
  };
  
}

#endif // _FS_OBJECT_SELECTOR_H_
