/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_IMAGEBOX_H_
#define _MFORMS_IMAGEBOX_H_

#include <mforms/base.h>
#include <mforms/view.h>


namespace mforms 
{
  class ImageBox;

#ifndef SWIG
  struct ImageBoxImplPtrs
  {
    bool (__stdcall *create)(ImageBox *);
    void (__stdcall *set_image)(ImageBox *, const std::string&);
  };
#endif

  class MFORMS_EXPORT ImageBox : public View
  {
  public:
    ImageBox();
    void set_image(const std::string &file);

  protected:
    ImageBoxImplPtrs *_imagebox_impl;
  };
};

#endif
