/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_LABEL_H_
#define _MFORMS_LABEL_H_

#include <mforms/base.h>
#include <mforms/view.h>


namespace mforms {
  class Label;

  enum Alignment
  {
    BottomLeft,
    BottomCenter,
    BottomRight,
    MiddleLeft,
    MiddleCenter,
    MiddleRight,
    TopLeft,
    TopCenter,
    TopRight,
    
    WizardLabelAlignment
  };

  enum LabelStyle
  {
    // normal text in normal system font
    NormalStyle,
    // same as above, but bold
    BoldStyle,
    // large text
    BigStyle,
    // same as above, but bold
    BigBoldStyle,
    // smaller than normal text
    SmallStyle,
    // As small as possible but still readable, for titles under widgets etc.
    VerySmallStyle,

    // style for showing some information, can be same as normal or a bit smaller
    InfoCaptionStyle,
    BoldInfoCaptionStyle,
    // wizard heading, in windows its blue, black elsewhere.. also bold and a bigger than normal
    WizardHeadingStyle,
    // description/help text to show for options, smaller than normal for fitting longer descriptions
    SmallHelpTextStyle
  };

#ifndef SWIG
  struct LabelImplPtrs
  {
    bool (__stdcall *create)(Label *self);
    void (__stdcall *set_style)(Label *self, LabelStyle style);
    void (__stdcall *set_text)(Label *self, const std::string &text);
    void (__stdcall *set_text_align)(Label *self, Alignment align);
    void (__stdcall *set_color)(Label *self, const std::string &color);
    void (__stdcall *set_wrap_text)(Label *self, bool flag);
  };
#endif

  class MFORMS_EXPORT Label : public View
  {
  public:
    Label(const std::string &text);
#ifndef SWIG
    Label();
#endif
    void set_wrap_text(bool flag);
    void set_text_align(Alignment align);
    void set_text(const std::string &text);
    void set_style(LabelStyle style);
    void set_color(const std::string &color);

  protected:
    LabelImplPtrs *_label_impl;
  };

};

#endif
