/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_LISTBOX_H_
#define _MFORMS_LISTBOX_H_

#include <mforms/view.h>

#include <vector>

namespace mforms {
  class ListBox;

#ifndef SWIG
  struct ListBoxImplPtrs
  {
    bool (__stdcall *create)(ListBox *self, bool multi_select);
    void (__stdcall *clear)(ListBox *self);
    void (__stdcall *set_heading)(ListBox *self, const std::string &text);
    void (__stdcall *add_items)(ListBox *self, const std::list<std::string> &items);
    int (__stdcall *add_item)(ListBox *self, const std::string &item);
    std::string (__stdcall *get_text)(ListBox *self);
    void (__stdcall *set_index)(ListBox *self, int index);
    int (__stdcall *get_index)(ListBox *self);
    std::vector<int> (__stdcall *get_selected_indices)(ListBox* self);
  };
#endif

  class MFORMS_EXPORT ListBox : public View
  {
  public:
    ListBox(bool multi);

    void clear();
    void set_heading(const std::string &text);
    int add_item(const std::string &item);
    void add_items(const std::list<std::string> &items);

    void set_selected(int index);

    virtual std::string get_string_value();
    int get_selected_index();
    std::vector<int> get_selected_indices(); // For multi selection lists.

#ifndef SWIG
    sigc::signal<void> signal_changed() { return _signal_changed; }

  public:
    void selection_changed();
#endif
  protected:
    ListBoxImplPtrs *_listbox_impl;

    sigc::signal<void> _signal_changed;
    
    bool _updating;
  };
};

#endif
