/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_MENU_H_
#define _MFORMS_MENU_H_

#include <mforms/base.h>

namespace mforms {
  class Menu;
  
#ifndef SWIG
  struct MFORMS_EXPORT MenuImplPtrs
  {
    bool (__stdcall *create)(Menu *self);
    
    void (__stdcall *remove_item)(Menu *self, int i);
    int (__stdcall *add_action)(Menu *self, const std::string &caption, const std::string &action);
    int (__stdcall *add_separator)(Menu *self);
    int (__stdcall *add_submenu)(Menu *self, const std::string &caption, Menu *submenu);
    
    void (__stdcall *set_item_enabled)(Menu *self, int i, bool flag);
    
    void (__stdcall *set_handler)(Menu *self, const sigc::slot<void, const std::string&> &action_handler);
    
    void (__stdcall *popup_at)(Menu *self, int x, int y);    
  };
#endif
  
  class MFORMS_EXPORT Menu : public Object, public sigc::trackable
  {
    MenuImplPtrs *_menu_impl;
    sigc::slot<void, const std::string&> _action_handler;

  public:
    Menu();

    void remove_item(int i);
    int add_action(const std::string &caption, const std::string &action);
    int add_separator();
    int add_submenu(const std::string &caption, Menu *submenu);

    void set_item_enabled(int i, bool flag);

    void set_handler(const sigc::slot<void, const std::string&> &action_handler);

    void popup_at(int x, int y);

  public:
    void handle_action(const std::string &action);
  };
};

#endif
