/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_H_
#define _MFORMS_H_

#include <mforms/base.h>
#include <mforms/view.h>
#include <mforms/form.h>
#include <mforms/button.h>
#include <mforms/checkbox.h>
#include <mforms/textentry.h>
#include <mforms/textbox.h>
#include <mforms/label.h>
#include <mforms/selector.h>
#include <mforms/listbox.h>
#include <mforms/tabview.h>
#include <mforms/box.h>
#include <mforms/panel.h>
#include <mforms/filechooser.h>
#include <mforms/radiobutton.h>
#include <mforms/imagebox.h>
#include <mforms/progressbar.h>
#include <mforms/table.h>
#include <mforms/scrollpanel.h>
#include <mforms/treeview.h>
#include <mforms/wizard.h>
#include <mforms/drawbox.h>
#include <mforms/tabswitcher.h>
#include <mforms/grttreeview.h>
#include <mforms/app.h>
#include <mforms/appview.h>
#include <mforms/utilities.h>
#include <mforms/uistyle.h>
#include <mforms/appview.h>
#include <mforms/sectionbox.h>
#include <mforms/widgets.h>
#include <mforms/menu.h>
#include <mforms/splitter.h>

namespace mforms
{
  class MFORMS_EXPORT ControlFactory
  {
  public:
    ViewImplPtrs _view_impl;
    FormImplPtrs _form_impl;
    BoxImplPtrs _box_impl;
    ButtonImplPtrs _button_impl;
    CheckBoxImplPtrs _checkbox_impl;
    TextEntryImplPtrs _textentry_impl;
    TextBoxImplPtrs _textbox_impl;
    LabelImplPtrs _label_impl;
    SelectorImplPtrs _selector_impl;
    ListBoxImplPtrs _listbox_impl;
    TabViewImplPtrs _tabview_impl;
    PanelImplPtrs _panel_impl;
    FileChooserImplPtrs _filechooser_impl;
    RadioButtonImplPtrs _radio_impl;
    ImageBoxImplPtrs _imagebox_impl;
    ProgressBarImplPtrs _progressbar_impl;
    TableImplPtrs _table_impl;
    ScrollPanelImplPtrs _spanel_impl;
    TreeViewImplPtrs _treeview_impl;
    WizardImplPtrs _wizard_impl;
    GRTTreeViewImplPtrs _grttreeview_impl;
    DrawBoxImplPtrs _drawbox_impl;
    MenuImplPtrs _menu_impl;
    SplitterImplPtrs _splitter_impl;

    AppImplPtrs _app_impl;
    AppViewImplPtrs _app_view_impl;
    UtilitiesImplPtrs _utilities_impl;
  public:
    ControlFactory();
    static ControlFactory *get_instance();
    
    void check_impl();
  };
};

#ifdef TEST
void MFORMS_EXPORT do_run_test();
#endif

#endif
