/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_PANEL_H_
#define _MFORMS_PANEL_H_

#include <mforms/view.h>


namespace mforms {
  enum PanelType {
    TransparentPanel, // just a container with no background
    FilledPanel,      // just a container with color filled background
    BorderedPanel,    // container with native border
    LineBorderPanel,  // container with a solid line border
    TitledBoxPanel,   // native grouping box with a title with border
    TitledGroupPanel, // native grouping container with a title (may have no border) 
    CheckBoxTitlePanel// container with checkbox
  };

  class Panel;

#ifndef SWIG
  struct MFORMS_EXPORT PanelImplPtrs
  {
    bool (__stdcall *create)(Panel*, PanelType type);
    void (__stdcall *set_back_color)(Panel*, const std::string &);
    void (__stdcall *set_title)(Panel*, const std::string&);

    void (__stdcall *set_active)(Panel*, bool);
    bool (__stdcall *get_active)(Panel*);
    
    void (__stdcall *set_padding)(Panel*, int);

    void (__stdcall *add)(Panel *self,View*);
    void (__stdcall *remove)(Panel *self,View*);
  };
#endif

  class MFORMS_EXPORT Panel : public View
  {
  public:
    Panel(PanelType type);
    void set_title(const std::string &title);
    void set_back_color(const std::string &color);

    void set_active(bool);
    bool get_active();
    
    void add(View *subview);
    virtual void remove(View *subview);
    void set_padding(int pad);

#ifndef SWIG
    sigc::signal<void> signal_toggled() { return _signal_toggled; }    
    
    void check_toggled();
#endif
  protected:
    sigc::signal<void> _signal_toggled;
    PanelImplPtrs *_panel_impl;
  };
};

#endif
