/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_PROGRESSBAR_H_
#define _MFORMS_PROGRESSBAR_H_

#include <mforms/base.h>
#include <mforms/view.h>


namespace mforms {
  class ProgressBar;

#ifndef SWIG
  struct ProgressBarImplPtrs
  {
    bool (__stdcall *create)(ProgressBar *self);
    void (__stdcall *set_value)(ProgressBar *self, float pct);
    void (__stdcall *set_indeterminate)(ProgressBar *self, bool flag);
    void (__stdcall *set_started)(ProgressBar *self, bool flag);
  };
#endif

  class MFORMS_EXPORT ProgressBar : public View
  {
  public:
    ProgressBar();

    // whether the progressbar knows how much actual progress was made
    void set_indeterminate(bool flag);
    void start();
    void stop();
    void set_value(float pct);

  protected:
    ProgressBarImplPtrs *_progressbar_impl;
  };
};


#endif /* _MFORMS_PROGRESSBAR_H_ */
