/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_RADIOBUTTON_H_
#define _MFORMS_RADIOBUTTON_H_

#include <mforms/base.h>
#include <mforms/view.h>


namespace mforms {
  
  class RadioButton;

#ifndef SWIG
  struct RadioButtonImplPtrs
  {
    bool (__stdcall *create)(RadioButton *self, int group_id);
    void (__stdcall *set_active)(RadioButton *self, bool flag);
    bool (__stdcall *get_active)(RadioButton *self);
  };
#endif

  class MFORMS_EXPORT RadioButton : public Button, public sigc::trackable
  {
  protected:
    RadioButtonImplPtrs *_radio_impl;

    sigc::signal<void> _signal_toggled;

    int _group_id;

    void radio_activated(int group_id);
      
  public:
    static int new_id();

    // the group_id defines the radiogroup this button belongs to.
    // when a radio group is activated, all others in the same group will be deactivated
    RadioButton(int group_id);

    int group_id() const { return _group_id; }
      
    void set_active(bool flag);
    bool get_active();

#ifndef SWIG
    sigc::signal<void> signal_toggled() { return _signal_toggled; }

    virtual void callback();
#endif
  };
};

#endif
