/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_SCROLLPANEL_H_
#define _MFORMS_SCROLLPANEL_H_

#include <mforms/panel.h>



namespace mforms {
  class ScrollPanel;

#ifndef SWIG
  struct MFORMS_EXPORT ScrollPanelImplPtrs
  {
    bool (__stdcall *create)(ScrollPanel*, bool bordered);

    void (__stdcall *add)(ScrollPanel*, View*);
    void (__stdcall *remove)(ScrollPanel*);
    
    void (__stdcall *set_visible_scrollers)(ScrollPanel*, bool vertical, bool horizontal);
    void (__stdcall *set_autohide_scrollers)(ScrollPanel*, bool flag);
  };
#endif

  class MFORMS_EXPORT ScrollPanel : public View
  {
  public:
    ScrollPanel(bool bordered);
    
    void set_visible_scrollers(bool vertical, bool horizontal);
    void set_autohide_scrollers(bool flag);
    
    void add(View *child);
    void remove();

  protected:
    View *_content;
    
    ScrollPanelImplPtrs *_spanel_impl;
  };
};

#endif /* _MFORMS_SCROLLPANEL_H_ */
