/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_POPUPSELECT_H_
#define _MFORMS_POPUPSELECT_H_

#include <mforms/view.h>


namespace mforms {
  class Selector;

  enum SelectorStyle
  {
    SelectorCombobox, // The value list is shown when clicking the arrow. The value is freely editable.
    SelectorPopup     // The value list is shown when clicking the arrow. The value can only be selected out of the
                      // values in the list and not freely edited.
  };

#ifndef SWIG
  struct SelectorImplPtrs
  {
    bool (__stdcall *create)(Selector *self, SelectorStyle style);
    void (__stdcall *clear)(Selector *self);
    void (__stdcall *add_items)(Selector *self, const std::list<std::string> &items);
    int (__stdcall *add_item)(Selector *self, const std::string &item);
    std::string (__stdcall *get_item)(Selector *self, int index);
    std::string (__stdcall *get_text)(Selector *self);
    void (__stdcall *set_index)(Selector *self, int index);
    int (__stdcall *get_index)(Selector *self);
    int (__stdcall *get_item_count)(Selector *self);
  };
#endif

  class MFORMS_EXPORT Selector : public View
  {
  public:
    Selector(SelectorStyle style= SelectorPopup);

    void clear();
    int add_item(const std::string &item);
    void add_items(const std::list<std::string> &items);

    std::string get_item_title(int i);
    
    void set_selected(int index);
    int index_of_item_with_title(const std::string &title);

    virtual std::string get_string_value();
    int get_selected_index();

    int get_item_count();

#ifndef SWIG
    sigc::signal<void> signal_changed() { return _signal_changed; }

  public:
    void callback();
#endif
  protected:
    SelectorImplPtrs *_selector_impl;
    sigc::signal<void> _signal_changed;
    bool _updating;
  };
};

#endif
