/* 
 * (c) 2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _MFORMS_SPLITTER_H_
#define _MFORMS_SPLITTER_H_

#include <mforms/view.h>
#include <map>

namespace mforms {
  
  class Splitter;
  
#ifndef SWIG
  struct SplitterImplPtrs
  {
    bool (__stdcall *create)(Splitter *self, bool horizontal);
    void (__stdcall *add)(Splitter *self, View *child, int minsize);
    void (__stdcall *remove)(Splitter *self, View *child);
    void (__stdcall *set_position)(Splitter *self, int);
  };
#endif
  
  class MFORMS_EXPORT Splitter : public View
  {
  public:
    Splitter(bool horiz);
    
    void add(View *subview, int minsize=0);
    virtual void remove(View *subview);
    
    void set_position(int position);
    
  protected:
    SplitterImplPtrs *_splitter_impl;
  };
  
};

#endif /* _MFORMS_SPLITTER_H_ */
