/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_TABLE_H_
#define _MFORMS_TABLE_H_

#include <mforms/base.h>
#include <mforms/view.h>


namespace mforms {

  class Table;
  
  enum TableItemFlags
  {
    VExpandFlag = (1 << 0),
    HExpandFlag = (1 << 1),
    VFillFlag = (1 << 2),
    HFillFlag = (1 << 3),

    FillAndExpand = HFillFlag| VFillFlag| VExpandFlag| HExpandFlag,
  };
  
  inline TableItemFlags operator| (TableItemFlags a, TableItemFlags b)
  {
    return (TableItemFlags)((int)a|(int)b);
  }

#ifndef SWIG
  struct MFORMS_EXPORT TableImplPtrs
  {
    bool (__stdcall *create)(Table*);

    void (__stdcall *set_row_count)(Table *self, int);
    void (__stdcall *set_column_count)(Table *self, int);

    void (__stdcall *add)(Table *self,View*, int, int, int, int, int);
    void (__stdcall *remove)(Table *self, View*);
    
    void (__stdcall *set_padding)(Table *self, int);

    void (__stdcall *set_row_spacing)(Table *self, int);
    void (__stdcall *set_column_spacing)(Table *self, int);

    void (__stdcall *set_homogeneous)(Table *self, bool);
  };
#endif

  class MFORMS_EXPORT Table : public View
  {
  public:
    Table();

    void set_row_count(int c);
    void set_column_count(int c);

    void set_row_spacing(int s);
    void set_column_spacing(int s);
    
    void set_padding(int pad);
    void set_homogeneous(bool value);

    void add(View *subview, int left, int right, int top, int bottom, int flags= HExpandFlag | VExpandFlag | HFillFlag | VFillFlag);
    
    virtual void remove(View *subview);

  protected:
    TableImplPtrs *_table_impl;
  };
};


#endif /* _MFORMS_TABLE_H_ */
