/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_TABVIEW_H_
#define _MFORMS_TABVIEW_H_

#include <mforms/view.h>

namespace mforms
{
  class TabView;

#ifndef SWIG
  struct MFORMS_EXPORT TabViewImplPtrs
  {
    bool (__stdcall *create)(TabView*,bool);
    void (__stdcall *set_active_tab)(TabView*,int);
    int (__stdcall *get_active_tab)(TabView*);
    int (__stdcall *add_page)(TabView*,View*,const std::string&);
  };
#endif

  class MFORMS_EXPORT TabView : public View
  {
    TabViewImplPtrs *_tabview_impl;

    sigc::signal<void> _signal_tab_changed;

  public:
    TabView(bool tabless = false);
    void set_active_tab(int index);
    int get_active_tab();
    int add_page(View *page, const std::string& caption);

#ifndef SWIG
    sigc::signal<void> signal_tab_changed() { return _signal_tab_changed; }
#endif
  };
};


#endif
