/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _MFORMS_TEXTENTRY_H_
#define _MFORMS_TEXTENTRY_H_

#include <mforms/view.h>

#include <sigc++/sigc++.h>

namespace mforms {
  class TextEntry;

  enum TextEntryType
  {
    NormalEntry,
    PasswordEntry,
    SearchEntry,
  };
  
  enum TextEntryAction
  {
    EntryActivate,
    EntryKeyUp,
    EntryKeyDown,
    EntryCKeyUp,
    EntryCKeyDown
  };

#ifndef SWIG
  struct TextEntryImplPtrs
  {
    bool (__stdcall *create)(TextEntry *self, TextEntryType type);
    void (__stdcall *set_text)(TextEntry *self, const std::string &text);
    void (__stdcall *set_max_length)(TextEntry *self, int len);
    std::string (__stdcall *get_text)(TextEntry *self);
    void (__stdcall *set_read_only)(TextEntry *self, bool flag);
  };
#endif

  class MFORMS_EXPORT TextEntry : public View
  {
  public:
    TextEntry(TextEntryType type = NormalEntry);

    void set_max_length(int len);
    void set_value(const std::string &text);
    virtual std::string get_string_value();
    void set_read_only(bool flag);

#ifndef SWIG
    sigc::signal<void> &signal_changed() { return _signal_changed; }
    sigc::signal<void, TextEntryAction> &signal_action() { return _signal_action; }

  public:
    void callback();
    void action(TextEntryAction action);
#endif
  protected:
    TextEntryImplPtrs *_textentry_impl;

    sigc::signal<void> _signal_changed;
    sigc::signal<void, TextEntryAction> _signal_action;
    
    bool _updating;
  };
};

#endif
