/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include "mforms/progressbar.h"
#include "mforms/mforms.h"

using namespace mforms;

ProgressBar::ProgressBar()
{
  _progressbar_impl= &ControlFactory::get_instance()->_progressbar_impl;

  _progressbar_impl->create(this);
}


void ProgressBar::set_value(float pct)
{
  _progressbar_impl->set_value(this, pct);
}


void ProgressBar::set_indeterminate(bool flag)
{
  _progressbar_impl->set_indeterminate(this, flag);
}


void ProgressBar::start()
{
  _progressbar_impl->set_started(this, true);
}


void ProgressBar::stop()
{
  _progressbar_impl->set_started(this, false);
}

