/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/mforms.h>
#include "mforms/scrollpanel.h"

using namespace mforms;


ScrollPanel::ScrollPanel(bool bordered)
  : View()
{
  _spanel_impl= &ControlFactory::get_instance()->_spanel_impl;

  _spanel_impl->create(this, bordered);
}



void ScrollPanel::add(View *child)
{
  child->retain();
  add_subview(child);
  child->set_parent(this);
  _spanel_impl->add(this, child);
  child->show();
  
  _content = child;
}


void ScrollPanel::remove()
{
  if (_content)
  {
    remove_subview(_content);
    _spanel_impl->remove(this);
    _content->release();
    _content = 0;
  }
}


void ScrollPanel::set_visible_scrollers(bool vertical, bool horizontal)
{
  _spanel_impl->set_visible_scrollers(this, vertical, horizontal);
}


void ScrollPanel::set_autohide_scrollers(bool flag)
{
  _spanel_impl->set_autohide_scrollers(this, flag);
}

