/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/selector.h>

#include <mforms/mforms.h>

using namespace mforms;


Selector::Selector(SelectorStyle style)
  : _updating(false)
{
  _selector_impl= &ControlFactory::get_instance()->_selector_impl;

  _selector_impl->create(this, style);
}


void Selector::clear()
{
  _selector_impl->clear(this);
}


int Selector::add_item(const std::string &item)
{
  _updating = true;
  int r= _selector_impl->add_item(this, item);
  _updating = false;
  return r;
}


void Selector::add_items(const std::list<std::string> &items)
{
  _updating = true;
  _selector_impl->add_items(this, items);
  _updating = false;
}


void Selector::set_selected(int index)
{
  _updating= true;
  _selector_impl->set_index(this, index);
  _updating= false;
}


std::string Selector::get_item_title(int index)
{
  return _selector_impl->get_item(this, index);
}


std::string Selector::get_string_value()
{
  return _selector_impl->get_text(this);
}


int Selector::index_of_item_with_title(const std::string &title)
{
  for (int i = 0; i < get_item_count(); i++)
    if (get_item_title(i) == title)
      return i;
  return -1;
}


int Selector::get_selected_index()
{
  return _selector_impl->get_index(this);
}


int Selector::get_item_count()
{
  return _selector_impl->get_item_count(this);
}

void Selector::callback()
{
  if (!_updating)
    _signal_changed.emit();
}
