/* 
 * (c) 2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "stdafx.h"

#include "mforms/splitter.h"
#include "mforms/mforms.h"


using namespace mforms;

Splitter::Splitter(bool horiz)
{
  _splitter_impl= &ControlFactory::get_instance()->_splitter_impl;
  
  _splitter_impl->create(this, horiz);
}


void Splitter::add(View *subview, int minsize)
{
  subview->retain();
  add_subview(subview);
  subview->set_parent(this);
  _splitter_impl->add(this, subview, minsize);
}

void Splitter::remove(View *subview)
{
  remove_subview(subview);
  _splitter_impl->remove(this, subview);
  subview->release();
}

void Splitter::set_position(int pos)
{
  _splitter_impl->set_position(this, pos);
}



