/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"
#include "../stub_treeview.h"

namespace mforms {
namespace stub {


TreeViewImpl::TreeViewImpl(TreeView *self, mforms::TreeOptions opts)
  : ViewImpl(self)
{
}


int TreeViewImpl::add_column(TreeColumnType type, const std::string &name, int initial_width, bool editable)
{
  return -1;
}


void TreeViewImpl::end_columns()
{
}



bool __stdcall TreeViewImpl::create(TreeView *self, mforms::TreeOptions opt)
{
  return new TreeViewImpl(self, opt) != 0;
}

int __stdcall TreeViewImpl::add_column(TreeView *self, TreeColumnType type, const std::string &name, int width, bool editable)
{
  return -1;
}

void __stdcall TreeViewImpl::end_columns(TreeView *self)
{
}

void __stdcall TreeViewImpl::clear_rows(TreeView *self)
{
}

void __stdcall TreeViewImpl::delete_row(TreeView *self, int row)
{
}

int __stdcall TreeViewImpl::add_row(TreeView *self)
{
  return -1;
}

int __stdcall TreeViewImpl::get_selected(TreeView *self)
{
  return -1;
}

void __stdcall TreeViewImpl::set_selected(TreeView* self, const int idx)
{
}

int __stdcall TreeViewImpl::count(TreeView *self)
{
  return 0;
}

void __stdcall TreeViewImpl::set_string(TreeView *self, int row, int column, const std::string &value)
{
}

void __stdcall TreeViewImpl::set_integer(TreeView *self, int row, int column, int value)
{
}

void __stdcall TreeViewImpl::set_check(TreeView *self, int row, int column, bool check)
{
}


std::string __stdcall TreeViewImpl::get_string(TreeView *self, int row, int column)
{
  return "";
}

int __stdcall TreeViewImpl::get_int(TreeView *self, int row, int column)
{
  return 0;
}
  
bool __stdcall TreeViewImpl::get_check(TreeView *self, int row, int column)
{
  return false;
}

std::string __stdcall TreeViewImpl::get_row_tag(TreeView *self, int row)
{
  return "";
}

void __stdcall TreeViewImpl::set_row_tag(TreeView *self, int row, const std::string &value)
{
}

void TreeViewImpl::init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

  f->_treeview_impl.create= &TreeViewImpl::create;
  f->_treeview_impl.add_column= &TreeViewImpl::add_column;
  f->_treeview_impl.end_columns= &TreeViewImpl::end_columns;
  f->_treeview_impl.clear_rows= &TreeViewImpl::clear_rows;
  f->_treeview_impl.delete_row= &TreeViewImpl::delete_row;
  f->_treeview_impl.add_row= &TreeViewImpl::add_row;
  f->_treeview_impl.get_selected= &TreeViewImpl::get_selected;
  f->_treeview_impl.set_selected= &TreeViewImpl::set_selected;
  f->_treeview_impl.count= &TreeViewImpl::count;
  f->_treeview_impl.set_string= &TreeViewImpl::set_string;
  f->_treeview_impl.set_int= &TreeViewImpl::set_integer;
  f->_treeview_impl.set_check= &TreeViewImpl::set_check;
  f->_treeview_impl.get_string= &TreeViewImpl::get_string;
  f->_treeview_impl.get_int= &TreeViewImpl::get_int; 
  f->_treeview_impl.get_check= &TreeViewImpl::get_check;
  f->_treeview_impl.set_row_tag= &TreeViewImpl::set_row_tag;
  f->_treeview_impl.get_row_tag= &TreeViewImpl::get_row_tag;
}

}
}
