/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_BUTTON_H_
#define _STUB_BUTTON_H_


#include "mforms/button.h"

#include "stub_view.h"


namespace mforms {
namespace stub {

class ButtonImpl : public ViewImpl
{
 protected:
  ButtonImpl(::mforms::Button *self, bool concrete= false)
    : ViewImpl(self)
  {
  }

  static void __stdcall callback(::mforms::Button* self)
  {
  }

  static bool __stdcall create(::mforms::Button *self)
  {
    return true;
  }

  static void __stdcall set_text(::mforms::Button *self, const std::string &text)
  {
  }

  static void __stdcall enable_internal_padding(Button *self, bool enabled)
  {
  }

public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_button_impl.create= &ButtonImpl::create;
    f->_button_impl.set_text= &ButtonImpl::set_text;
    f->_button_impl.enable_internal_padding= &ButtonImpl::enable_internal_padding;
  }
};

}
}

#endif
