/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_FORM_H_
#define _STUB_FORM_H_

#include <mforms/mforms.h>

#include "stub_button.h"
#include "stub_view.h"
#include "stub_mforms.h"

namespace mforms {
namespace stub {

class FormImpl : public ViewImpl
{ 
  static bool __stdcall create(::mforms::Form *self, ::mforms::Form *owner, mforms::FormFlag flag);
  static void __stdcall set_title(::mforms::Form *self, const std::string &title);
  void accept_clicked(bool *status, const bool is_run);
  void cancel_clicked(bool *status, const bool is_run);
  static void __stdcall show_modal(::mforms::Form *self, ::mforms::Button *accept, ::mforms::Button *cancel);
  static bool __stdcall run_modal(::mforms::Form *self, ::mforms::Button *accept, ::mforms::Button *cancel);
  static void __stdcall close(::mforms::Form *self);
  static void __stdcall set_content(::mforms::Form *self, ::mforms::View *child);
  static void __stdcall flush_events(::mforms::Form *self);
  static void __stdcall center(Form *self);
  FormImpl(::mforms::Form *form, ::mforms::Form *owner, mforms::FormFlag form_flag);
  virtual void set_size(int width, int height);

public:
  static void init();
};

};
};

#endif
