/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_GRTTREEVIEW_H_
#define _STUB_GRTTREEVIEW_H_


#include "mforms/grttreeview.h"

#include "stub_view.h"

namespace mforms {
namespace stub {

class GRTTreeViewImpl : public ViewImpl
{
protected:
  GRTTreeViewImpl(::mforms::GRTTreeView *self)
    : ViewImpl(self)
  {
  }

  static bool __stdcall create(::mforms::GRTTreeView *self, bool has_border)
  {
    return true;
  }

  static void __stdcall set_model(::mforms::GRTTreeView *self, bec::TreeModel *model)
  {
  }

  static int __stdcall add_column(::mforms::GRTTreeView *self, ::mforms::GRTTreeColumnType type, int model_column, const std::string &name)
  {
    return 0;
  }

  static int __stdcall add_column_editable(::mforms::GRTTreeView *self, ::mforms::GRTTreeColumnType type, int model_column, const std::string &name)
  {
    return 0;
  }

  static void __stdcall set_column_width(::mforms::GRTTreeView *self, int model_column, int width)
  {
  }

  static void __stdcall refresh(::mforms::GRTTreeView *self, const bec::NodeId &node)
  {
  }

  static void __stdcall set_allow_multi_selection(::mforms::GRTTreeView *self, bool)
  {
  }

  static bool __stdcall get_selected_node(::mforms::GRTTreeView *self, bec::NodeId &node)
  {
    return false;
  }

  static int __stdcall get_selection(::mforms::GRTTreeView *self, std::vector<bec::NodeId> &nodes)
  {
    return 0;
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();

    f->_grttreeview_impl.create         = &GRTTreeViewImpl::create;
    f->_grttreeview_impl.set_model      = &GRTTreeViewImpl::set_model;
    f->_grttreeview_impl.add_column       = &GRTTreeViewImpl::add_column;
    f->_grttreeview_impl.add_column_editable = &GRTTreeViewImpl::add_column_editable;
    f->_grttreeview_impl.set_column_width      = &GRTTreeViewImpl::set_column_width;
    f->_grttreeview_impl.refresh  = &GRTTreeViewImpl::refresh;
    f->_grttreeview_impl.set_allow_multi_selection  = &GRTTreeViewImpl::set_allow_multi_selection;
    f->_grttreeview_impl.get_selected_node  = &GRTTreeViewImpl::get_selected_node;
    f->_grttreeview_impl.get_selection  = &GRTTreeViewImpl::get_selection;
  }
};

};
};


#endif
