/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_LISTBOX_H_
#define _STUB_LISTBOX_H_


#include "mforms/listbox.h"

#include "stub_view.h"

namespace mforms
{
namespace stub
{

class ListBoxImpl : public ViewImpl
{
protected:
  ListBoxImpl(::mforms::ListBox *self, bool multi_select);
  static void __stdcall selection_changed(::mforms::ListBox *self);
  static bool __stdcall create(::mforms::ListBox *self, bool multi_select);
  static void __stdcall clear(::mforms::ListBox *self);
  static int __stdcall add_item(::mforms::ListBox *self, const std::string &item);
  static void __stdcall add_items(::mforms::ListBox *self, const std::list<std::string> &items);
  static std::string __stdcall get_text(::mforms::ListBox *self);
  static void __stdcall set_index(::mforms::ListBox *self, int index);
  static int __stdcall get_index(::mforms::ListBox *self);
  static void __stdcall set_heading(ListBox *self, const std::string &text);
  static std::vector<int> __stdcall get_selected_indices(ListBox *self);

 public:
  static void init();
};

}
}

#endif /* _STUB_LISTBOX_H_ */
