/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef _STUB_TEXTBOX_H_
#define _STUB_TEXTBOX_H_

#include <mforms/mforms.h>

#include "stub_view.h"


namespace mforms {
namespace stub {

class TextBoxImpl : public ViewImpl
{
  TextBoxImpl(::mforms::TextBox *self, mforms::ScrollBars scroll_type);

  static bool __stdcall create(::mforms::TextBox *self, mforms::ScrollBars scroll_type);
  static void __stdcall set_text(::mforms::TextBox *self, const std::string &text);
  static void __stdcall append_text(::mforms::TextBox *self, const std::string &text, bool scroll_to_end);
  static std::string __stdcall get_text(::mforms::TextBox *self);
  static void __stdcall set_read_only(::mforms::TextBox *self, bool flag);
  static void __stdcall set_padding(::mforms::TextBox *self, int pad);
  static void __stdcall set_bordered(::mforms::TextBox *self, bool flag);
  static void __stdcall clear(::mforms::TextBox *self);

public:
  static void init();
};

  };
};

#endif
