/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/textentry.h>
#include <mforms/mforms.h>

using namespace mforms;

TextEntry::TextEntry(TextEntryType type)
  : _updating(false)
{
  _textentry_impl= &ControlFactory::get_instance()->_textentry_impl;

  _textentry_impl->create(this, type);
}


void TextEntry::set_value(const std::string &text)
{
  _updating= true;
  _textentry_impl->set_text(this, text);
  _updating= false;
}


void TextEntry::set_max_length(int len)
{
  _textentry_impl->set_max_length(this, len);
}


std::string TextEntry::get_string_value()
{
  return _textentry_impl->get_text(this);
}


void TextEntry::callback()
{
  if (!_updating)
    _signal_changed.emit();
}


void TextEntry::action(TextEntryAction action)
{
  _signal_action.emit(action);
}

void TextEntry::set_read_only(bool flag)
{
  _textentry_impl->set_read_only(this, flag);
}