/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include "test.h"
#include "mforms/utilities.h"

using namespace mforms;

BEGIN_TEST_DATA_CLASS(mforms_utilities_test)
END_TEST_DATA_CLASS;

TEST_MODULE(mforms_utilities_test, "mforms utilities testing");

TEST_FUNCTION(1)
{
  std::string service= "A quick brown fox jumps over the lazy dog. ";
  std::string user_name= "father abraham";
  std::string the_password= "!$%&dingeling 123@";

  std::string result;
  ensure("Reading non-existing password", !Utilities::find_password("out of service", "don't call me, I call you", result));
  Utilities::store_password(service, user_name, the_password);//ensure("Writing a password", Utilities::store_password(service, user_name, the_password));
  ensure("Reading password back", Utilities::find_password(service, user_name, result));
  ensure_equals("Comparing returned to stored password", the_password, result);

}

END_TESTS
