/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/**
 * Contains the implementation of the wrapper for a .NET form used by the mforms backend.
 */

#include "stdafx.h"

#include "wf_appview.h"

using namespace MySQL::Forms;

//--------------------------------------------------------------------------------------------------

bool AppViewImpl::create(::mforms::AppView *self, bool horizontal)
{
  AppViewImpl^ appview= gcnew AppViewImpl(self);

  if (appview != nullptr)
  {
    // The next steps are the same as with a BoxImpl.
    Box^ native_box= ViewImpl::create<Box>(self, appview);
    native_box->Horizontal= horizontal;
    appview->setup();
    self->set_resize_mode(::mforms::ResizeNone);

    // Allocating the app view will set its ref count to 1. We don't keep a reference here, though
    // (the appview dock content does and hence will manage the AppView's life time).
    appview->get_unmanaged_object()->release();

    return true;
  }
  return false;
}

//--------------------------------------------------------------------------------------------------

void AppViewImpl::DocumentClosing(System::Object^ sender, TabClosingEventArgs^ e)
{
  Control^ control= get_control<Control>();

  if (control->Tag != nullptr)
  {
    ::mforms::AppView* view= ViewImpl::get_backend_control<::mforms::AppView>(control);
    if (view != NULL)
      e->canClose= view->on_close();
  }
}

//--------------------------------------------------------------------------------------------------

AppViewImpl::AppViewImpl(::mforms::AppView* app)
  : BoxImpl(app), _appView(app)
{
}

//--------------------------------------------------------------------------------------------------

void AppViewImpl::setup()
{
  // In order to ease maintenance we create a special document host for our content.
  _host= gcnew AppViewDockContent(this);
  Control^ control= get_control<Control>();
  _host->Controls->Add(control);
  control->Dock= DockStyle::Fill;
}

//----------------- AppViewDockContent -------------------------------------------------------------

AppViewDockContent::AppViewDockContent(AppViewImpl^ appview)
{
  _appview= appview;
  _appview->get_unmanaged_object()->retain();
};

//--------------------------------------------------------------------------------------------------

AppViewDockContent::~AppViewDockContent()
{
  _appview->get_unmanaged_object()->release();
  _appview= nullptr;
}

//--------------------------------------------------------------------------------------------------

AppViewImpl^ AppViewDockContent::GetAppView()
{
  return _appview;
};

//--------------------------------------------------------------------------------------------------

mforms::AppView* AppViewDockContent::get_unmanaged_object()
{
  return _appview->get_unmanaged_object();
}

//--------------------------------------------------------------------------------------------------

