/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_APPVIEW_H_
#define _WF_APPVIEW_H_

#include "mforms/appview.h"
#include "wf_box.h"

using namespace MySQL::Controls;

namespace MySQL {
  namespace Forms {

    // A managed version of the AppView class.
    public ref class AppViewImpl : public BoxImpl
    {
    private:
      TabDocument^ _host; // The document we dock our content to.
      mforms::AppView* _appView;
    protected:
      static bool create(::mforms::AppView *self, bool horizontal);

      void setup();
    public:
      AppViewImpl(::mforms::AppView* app);

      mforms::AppView *get_unmanaged_object() { return _appView; }

      TabDocument^ GetHost() { return _host; };
      void DocumentClosing(System::Object^ sender, TabClosingEventArgs^ e);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::AppView*, bool, mgr, f->_app_view_impl, AppViewImpl, create);
      }
    };

    // Make an own class for the dock content, so we can later check for it.
    public ref class AppViewDockContent : public TabDocument
    {
    private:
      AppViewImpl^ _appview;

    public:
      AppViewDockContent(AppViewImpl^ appview);
      ~AppViewDockContent();

      AppViewImpl^ GetAppView();
      mforms::AppView *get_unmanaged_object();
    };

  };
};

#endif
