/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"
#include "wf_button.h"

using namespace MySQL;
using namespace MySQL::Forms;

//-------------------------------------------------------------------------------------------------

ButtonImpl::ButtonImpl(::mforms::Button *self)
  : ViewImpl(self)
{
}

//-------------------------------------------------------------------------------------------------

bool ButtonImpl::create(::mforms::Button *self)
{
  ButtonImpl ^button= gcnew ButtonImpl(self);

  if (button != nullptr)
  {
    Windows::Forms::Button ^b= ViewImpl::create<Button>(self, button);
    b->AutoSize= true;
    b->AutoSizeMode= AutoSizeMode::GrowAndShrink;
    b->UseMnemonic= true;
    b->Click += gcnew System::EventHandler(&ButtonImpl::button_click);
    return true;
  }
  return false;
}

//-------------------------------------------------------------------------------------------------

void ButtonImpl::set_text(::mforms::Button *self, const std::string &text)
{
  ButtonImpl^ button= (ButtonImpl^)ObjectImpl::FromUnmanaged(self);

  if (button != nullptr)
  {
    std::string tmp;
  
    if (text.find('_') != std::string::npos)
    {
      tmp.append(text.substr(0, text.find('_')));
      tmp.append("&");
      tmp.append(text.substr(text.find('_')+1));
    }
    else
      tmp= text;

    Control^ control= button->get_control<Control>();
    control->Text= CppStringToNative(tmp);

    // Resize the button to fit its content.
    Size size= control->PreferredSize;
    if (size.Width < control->Width)
      size.Width= control->Width;
    if (size.Height < control->Height)
      size.Height= control->Height;
    control->Size= size;
  }
}

//-------------------------------------------------------------------------------------------------

void ButtonImpl::button_click(System::Object ^sender, System::EventArgs ^e)
{
  Windows::Forms::Button^ btn= (Windows::Forms::Button^)sender;

  if (btn->Tag != nullptr)
  {
    ::mforms::Button* button= ViewImpl::get_backend_control<::mforms::Button>(btn);
    if (button != 0)
      button->callback();
  }
}

//-------------------------------------------------------------------------------------------------

void ButtonImpl::enable_internal_padding(::mforms::Button *self, bool flag)
{
  ButtonImpl^ button= (ButtonImpl^)ObjectImpl::FromUnmanaged(self);

  // The internal padding feature is just some beautfying added to the button
  // gives it a bit more room left and right of the text than what is the default
  // for it.
  
  Button^ native_button= button->get_control<Button>();
  if (flag)
  {
    if (native_button->Padding.Left == 0)
    {
      // Only add extra padding if that didn't happen already.
      int extra= native_button->Height / 2;
      native_button->Padding= Padding::Add(native_button->Padding, Padding(extra, 0, extra, 0));
    }
  }
  else
  {
    native_button->Padding= Padding(0, 0, 0, 0);
  }
}

//-------------------------------------------------------------------------------------------------

