/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_IMAGEBOX_H_
#define _WF_IMAGEBOX_H_

#include "mforms/mforms.h"
#include "mforms/app.h"

#include "wf_view.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    public ref class ImageBoxImpl : public ViewImpl
    {
      static bool create(::mforms::ImageBox *self)
      {
        ImageBoxImpl ^cb= gcnew ImageBoxImpl(self);

        if (cb != nullptr)
        {
          PictureBox ^pb= ViewImpl::create<PictureBox>(self, cb);
          pb->SizeMode = PictureBoxSizeMode::AutoSize;
          return true;
        }
        return false;
      }

      static void set_image(::mforms::ImageBox *self, const std::string &file)
      {
        ImageBoxImpl^ cb= (ImageBoxImpl^)ObjectImpl::FromUnmanaged(self);

        if (cb != nullptr && !file.empty())
        {
          PictureBox^ box= cb->get_control<PictureBox>();
          String^ name= CppStringToNative(mforms::App::get()->get_resource_path(file));
          
          try
          {
            if (IO::File::Exists(name))
              box->Load(name);
            else
              box->Load(Application::StartupPath + "\\" + name);
          }
          catch (...)
          {
            // Ignore image load errors.
          }
        }
      }

      ImageBoxImpl(::mforms::ImageBox *image)
        : ViewImpl(image)
      {
      }

    public:
      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, ::mforms::ImageBox*, mgr, f->_imagebox_impl, ImageBoxImpl, create);
        DEF_CALLBACK2(void, ::mforms::ImageBox*, const std::string&, mgr, f->_imagebox_impl, ImageBoxImpl, set_image);
      }
    };

  };
};

#endif
