/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _WF_PANEL_H_
#define _WF_PANEL_H_


#include "mforms/panel.h"

#include "wf_view.h"

using namespace System::Windows::Forms;
using namespace Layout;

namespace MySQL {
  namespace Forms {

    private ref class FillLayout : public LayoutEngine
    {
    public:
      virtual bool Layout(Object^ container, LayoutEventArgs^ arguments) override;
      Drawing::Size GetMinimumSize(Control^ container);
    };

    /**
     * A group box with a fill layout.
     */
    public ref class FillGroupBox : public GroupBox
    {
    private:
      FillLayout^ layoutEngine;
      Drawing::Size preferredSize;
    public:
      FillGroupBox()
      {
        preferredSize= Drawing::Size(0, 0);
      }

      virtual Drawing::Size GetPreferredSize(Drawing::Size proposedSize) override;

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew FillLayout();

          return layoutEngine;
        }
      }

      void SetPreferredSize(const Drawing::Size% size) { preferredSize= size; };
    };

    /**
     * A panel with a fill layout.
     */
    public ref class FillPanel : public Panel
    {
    private:
      FillLayout^ layoutEngine;
      Drawing::Size preferredSize;
    public:
      FillPanel()
      {
        preferredSize= Drawing::Size(0, 0);
      }

      virtual Drawing::Size GetPreferredSize(Drawing::Size proposedSize) override;

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew FillLayout();

          return layoutEngine;
        }
      }

      void SetPreferredSize(const Drawing::Size% size) { preferredSize= size; };
    };

    public ref class PanelImpl : public ViewImpl
    {
    private:
      ::mforms::View *_child;
      ::mforms::PanelType type;

    protected:
      PanelImpl(::mforms::View *self)
        : ViewImpl(self)
      {
      }

      static bool create(::mforms::Panel *self, ::mforms::PanelType panelType);
      static void set_title(::mforms::Panel *self, const std::string &title);
      static void set_back_color(::mforms::Panel *self, const std::string &color);
      static void add(::mforms::Panel *self, ::mforms::View *view);
      static void set_active(::mforms::Panel* self, bool value);
      static bool get_active(::mforms::Panel* self);
      static void set_padding(::mforms::Panel* self, int value);
      static void remove(::mforms::Panel *self, ::mforms::View* view);

    public:
      static void set_preferred_size(Control^ control, const Size% size);

      virtual void set_title(const std::string &title);
      virtual void set_back_color(const std::string &color);
      virtual void add(::mforms::View *view);
      virtual void set_active(bool value);
      virtual bool get_active();
      virtual void set_padding(int value);
      virtual void remove(::mforms::View* view);
      virtual void remove();

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::Panel*, ::mforms::PanelType, mgr, f->_panel_impl, PanelImpl, create);
        DEF_CALLBACK2(void, ::mforms::Panel*, const std::string&, mgr, f->_panel_impl, PanelImpl, set_title);
        DEF_CALLBACK2(void, ::mforms::Panel*, ::mforms::View*, mgr, f->_panel_impl, PanelImpl, add);
        DEF_CALLBACK2(void, ::mforms::Panel*, const std::string&, mgr, f->_panel_impl, PanelImpl, set_back_color);
        DEF_CALLBACK2(void, ::mforms::Panel*, bool, mgr, f->_panel_impl, PanelImpl, set_active);
        DEF_CALLBACK1(bool, ::mforms::Panel*, mgr, f->_panel_impl, PanelImpl, get_active);
        DEF_CALLBACK2(void, ::mforms::Panel*, int, mgr, f->_panel_impl, PanelImpl, set_padding);
        DEF_CALLBACK2(void, ::mforms::Panel*, ::mforms::View*, mgr, f->_panel_impl, PanelImpl, remove);
      }
    };

  };
};


#endif
