/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA 02110-1301  USA.
 */

#ifndef _WF_SELECTOR_H_
#define _WF_SELECTOR_H_


#include "mforms/selector.h"

#include "wf_view.h"

using namespace System;
using namespace Windows::Forms;

namespace MySQL {
  namespace Forms {

    /**
     * Helper class for drawing separator lines in a combobox.
     */
    public ref class SeparatorItem
    {
    private:
      Object^ _data;
    public:
      SeparatorItem(Object^ data) {
        _data = data;
      }

      virtual String^ ToString() override
      {
        if (_data != nullptr) {
            return _data->ToString();
        }
        return "";
      }
    };

    public ref class SelectorImpl : public ViewImpl
    {
    protected:
      SelectorImpl(mforms::Selector *self);
      
      static bool create(mforms::Selector *self, mforms::SelectorStyle style);
      static void clear(mforms::Selector *self);
      static int add_item(mforms::Selector *self, const std::string &item);
      static void add_items(mforms::Selector *self, const std::list<std::string> &items);
      static std::string get_text(mforms::Selector *self);
      static void set_index(mforms::Selector *self, int index);
      static std::string get_item(mforms::Selector *self, int index);
      static int get_index(mforms::Selector *self);
      static int get_item_count(mforms::Selector *self);

      // Event handlers
      static void selection_changed(System::Object ^sender, System::EventArgs ^e);
      static void SelectorImpl::measure_item(Object^ sender, MeasureItemEventArgs^ args);
      static void SelectorImpl::draw_item(Object^ sender, DrawItemEventArgs^ args);
      static void key_press(System::Object ^sender, KeyPressEventArgs ^e);
    public:
      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, mforms::Selector*, mforms::SelectorStyle, mgr, f->_selector_impl, SelectorImpl, create);
        DEF_CALLBACK1(void, mforms::Selector*, mgr, f->_selector_impl, SelectorImpl, clear);
        DEF_CALLBACK2(int, mforms::Selector*, const std::string&, mgr, f->_selector_impl, SelectorImpl, add_item);
        DEF_CALLBACK2(void, mforms::Selector*, const std::list<std::string>&, mgr, f->_selector_impl, SelectorImpl, add_items);
        DEF_CALLBACK2(void, mforms::Selector*, int, mgr, f->_selector_impl, SelectorImpl, set_index);
        DEF_CALLBACK2(std::string, mforms::Selector*, int, mgr, f->_selector_impl, SelectorImpl, get_item);
        DEF_CALLBACK1(std::string, mforms::Selector*, mgr, f->_selector_impl, SelectorImpl, get_text);
        DEF_CALLBACK1(int, mforms::Selector*, mgr, f->_selector_impl, SelectorImpl, get_index);
        DEF_CALLBACK1(int, mforms::Selector*, mgr, f->_selector_impl, SelectorImpl, get_item_count);
      }
    };

  };
};


#endif
